#!/usr/bin/perl
require "cgi-lib.pl";
&ReadParse(*INPUT);

###########################  WARP 1.0  ###################################
####                     Andrew J. Smith                              ####
#################  WEB ACCESS RESERVE PROGRAM  ###########################
####	This program will read the Web:/generalwebserverdirectory/library
####	folder and its subdirectories and give HTML back.  This is an
####	electronic reserve program for use in academic libraries.
##########################################################################
####    Copyright  2000 by Andrew J Smith. All rights reserved. 
####    Permission granted to use and modify this program so long as the
####    copyright above is maintained, modifications are documented, and
####    credit is given for any use of the program. Notify author at
####    mailto: ajsmith@olivet.edu

##########################################################################
####  Consultant: Craighton Hippenhammer, Information Technology Librarian
####  Benner Library & Resource Center, Olivet Nazarene University
####  For all library use questions contact Professor Hippenhammer
####  mailto: chhammer@olivet.edu

##########################################################################
####    Variable Declarations
##########################################################################

$PROF_NAME = $INPUT{'prof_name'};
$CLASS_NUM = $INPUT{'class_num'};

##########################################################################
####    The header.txt and footer.txt files together make up the web page
####    on which the professor's names and class numbers appear.

$banner_file = "/generalwebserverdirectory/library/header.txt";
$footer_file = "/generalwebserverdirectory/library/footer.txt";

##########################################################################
####    The URL of the page that is returned when access is rejected.
$redirect_url = "http://web.myschool.edu/reject.html";

##########################################################################
####	main program
##########################################################################

####  Check for school IP addresses which are allowed; all others rejected
####  Access to ereserve must be restricted due to copyright laws.
##########################################################################

if ( $ENV{REMOTE_ADDR} !~ /(111.11.)|(222.222.2)|(333.33.)|(444.444.4.44)/ ) {
   print "Location: $redirect_url\n\n";
   exit;
}

##########################################################################

if (($PROF_NAME) && ($CLASS_NUM)) {
    &print_all_info;
} elsif (($PROF_NAME) && (!$CLASS_NUM)) {
    &get_prof_info;
} else {
    &get_direct_struct;
}

sub print_all_info {
   opendir(DIR, "/generalwebserverdirectory/library/$PROF_NAME/$CLASS_NUM/");

# || print "<DD><B>No Files Currently Available</B>\n";

   @directory = readdir(DIR);
   @temp = sort @directory;
   @directory = @temp;
   $num_of_items = scalar(@directory + 0);

   print "Content-type: text/html\n\n";

   open (headerfile, "$banner_file");
     @lines = <headerfile>;
     close (headerfile);
   print @lines;

	if ( $num_of_items == "" ) {
	   print "<CENTER><B>No Files Currently Available</B>\n";
        } else {
	   print "<center><table border=2>\n";
	   print "<TR>\n";
	   print "<!--   <TD><B>Web Page Format</B></TD> <TD WIDTH=20></TD> -->\n";
           print "<TD><B>Adobe Acrobat Format</B></TD></TR>\n";
        }

   for ($x = 0; $x <= $num_of_items; $x++) {
	if (($directory[$x])) {
	   if (lc($directory[$x]) =~ "pdf") {
	      $file_name = $directory[$x];
	      $file_name =~ s/pdf/html/i;
	      $pdf_file = $directory[$x];
	      $pdf_file =~ s/ /\%20/g;
	      $prof_name2 = $PROF_NAME;
	      $prof_name2 =~ s/ /\%20/g;
	      $class_num2 = $CLASS_NUM;
	      $class_num2 =~ s/ /\%20/g;
	      print "<tr>
			<td><a href=\"/library/$prof_name2/$class_num2/$pdf_file\">$directory[$x]</a></td>
			</tr>\n";
	   }
	}
   }
print <<EOT;
</table>
</center>
EOT

open (footerfile, "$footer_file");
  @lines = <footerfile>;
  close (footerfile);
print @lines;
}   

sub get_direct_struct {
   print "Content-type: text/html\n\n";

   open (headerfile, "$banner_file");
	@lines = <headerfile>;
	close (headerfile);
   print @lines;

####################################################################
# put the absolute directory right here !!!!!!!!!!!!!!!!!!!!!!!    #
#                |                                                 #
#                V                                                 #

   opendir(DIR, "/generalwebserverdirectory/library/") || print "<DD>No Files Currently Available\n";
   @directory = readdir(DIR);
   @temp = sort @directory;
   @directory = @temp;
   $num_of_profs = scalar(@directory + 0);
   close(DIR);

   for ($i=0; $i<$num_of_profs; $i++) {
       if ($directory[$i] ne "header.txt" ) {
	   if ($directory[$i] ne "footer.txt" ) {
		  $directory2 = $directory[$i];
		  $directory2 =~ s/ /\%20/gi;
		  print "<A HREF=\"reserve.pl?prof_name=$directory2\"><FONT SIZE=+1>$directory[$i]</FONT></A><BR>\n";
	   }
       }
   }
      print "</BLOCKQUOTE></BLOCKQUOTE>\n";
open (footerfile, "$footer_file");
  @lines = <footerfile>;
  close (footerfile);
print @lines;

}

sub get_prof_info {
   print "Content-type: text/html\n\n";
  open (headerfile, "$banner_file");
     @lines = <headerfile>;
     close (headerfile);
   print @lines;
   print "\n";
 

####################################################################
# put the absolute directory right here !!!!!!!!!!!!!!!!!!!!!!!    #
#                |                                                 #
#                V                                                 #

   opendir(DIR, "/generalwebserverdirectory/library/") || print "<DD>No Files Currently Available\n";
   @directory = readdir(DIR);
   @temp = sort @directory;
   @directory = @temp;
   $num_of_profs = scalar(@directory + 0);
   close(DIR);

   for ($i=0; $i<$num_of_profs; $i++) {
       if ($directory[$i] ne "header.txt" ) {
	if ($directory[$i] ne "footer.txt" ) {
	  $space_out = $directory[$i];
	  $space_out =~ s/ /\%20/g;

########################################################################################
#### Compare user browser for IE vs. Netscape.  Netscape requires %20 in place of spaces 
#### which IE can handle natively
####
########################################################################################
	  $user_browser = $ENV{HTTP_USER_AGENT};
	  if ( $user_browser =~ /MSIE/ig ) {
		 print "<A HREF=\"reserve.pl?prof_name=$directory[$i]\"><FONT SIZE=+1>$directory[$i]</FONT></A><BR>\n";
	  }
	  else {
		 print "<A HREF=\"reserve.pl?prof_name=$space_out\"><FONT SIZE=+1>$directory[$i]</FONT></A><BR>\n";
	  }

	  if ($directory[$i] eq $PROF_NAME) {

#####################################################################
# put the absolute directory right here !!!!!!!!!!!!!!!!!!!!!!!     #
#                                  |                                #
#                                  V                                #
		
		opendir(PROF_DIR, "/generalwebserverdirectory/library/$PROF_NAME/") || print "<DD>No Files Currently Available\n";
		@prof_dir = readdir(PROF_DIR);
		@temp = sort @prof_dir;
		@prof_dir = @temp;
		$num_of_classes = scalar(@prof_dir + 0);
		close(PROF_DIR);

		print "<OL>\n";
		for ($x=0; $x<$num_of_classes; $x++) {
			$directory_sans_space = $directory[$i];
			$directory_sans_space =~ s/ /\%20/g;

			$prof_dir_sans_space = $prof_dir[$x];
			$prof_dir_sans_space =~ s/ /\%20/g;

	   		print "<LI><A HREF=\"reserve.pl?prof_name=$directory_sans_space&class_num=$prof_dir_sans_space\">$prof_dir[$x]</A></LI>\n";
		}       

		print "</OL>\n";		   
		print "\n";
	   }
	 }
       }
   }
   print "</BLOCKQUOTE></BLOCKQUOTE>\n";
open (footerfile, "$footer_file");
  @lines = <footerfile>;
  close (footerfile);
print @lines;
   print "\n";

}  
